%Plot the various H/D charged data

%
data=csvread('charge-comparison.csv');

%create figuire
figure

%Loop over 4 scenarios

titles = { ['Uncharged'], ['H Charged'],['D charged, with cryo'], ['D Charged, without cryo'] }
reorder=[1 2 4 3];

for i=1:4
  subplot(4,1,i);
  j=reorder(i)
  x=data(:,2*j-1);
  y=data(:,2*j);
  
  %Snip out the < mass=5 range
  subx_idx=find(x < 5.0 & x > 0.75);
  subx=x(subx_idx);
  suby=y(subx_idx);
 
  %Remove background
  background = mean(y(find(x>4.0 & x < 5.0)));
  suby= suby-background;
 
  %Normalise count to max intensity
  
  suby = suby/max(suby);

  %Plot the line
  plot(subx,suby);
 
  xlabel('Mass-to-Charge (Da)')
  ylabel('relative intensity');
  
  title(titles{j})
  
  axis( [0.5 5.0 -0.1 1.1])
  
end
